-- Udaipur

-- Infirmaty Clinic Parent

set sql_safe_updates=0;

SET @clinicDtProviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='CLINIC_APPOINTMENT_PARENT_DL');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T2.id AS USER_ID
FROM
    parent_infirmary_details T2
        INNER JOIN
    infirmary_details T1 ON T1.id = T2.infirmaryId
WHERE
    T1.type = 'CLINIC'
        AND T1.whetherParentInformed = TRUE
        AND T2.infirmaryId IN (namedParams)" WHERE `dataProviderId`=@clinicDtProviderId;
        
SET @clinicDtProviderId1=(SELECT id FROM dtprovider WHERE `dataProviderName`='CLINIC_APPOINTMENT_PARENT_RCPNT');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    pid.id AS ID,
    perPer.`firstName` AS FIRST_NAME,
    perPer.`lastName` AS LAST_NAME,
    perPer.printName AS PRINT_NAME,
    perPer.`emailId` AS EMAIL_ID,
    perPer.`mobileNumber` AS MOBILE_NO,
    doc.printName AS DOC_PRINT_NAME,
    doc.firstName AS DOC_FIRST_NAME,
    doc.lastName AS DOC_LAST_NAME,
    stu.printName AS STUDENT_PRINT_NAME,
    stu.firstName AS STUDENT_FIRST_NAME,
    stu.lastName AS STUDENT_LAST_NAME,
    T2.sectionCode AS SECTION_CODE,
    infRes.itemValue AS REASON,
    DATE_FORMAT(T1.infirmaryDate, '%d-%m-%Y') AS VISIT_DATE,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T8.academyName AS ACADEMY_NAME,
    (SELECT 
            GROUP_CONCAT(DISTINCT deviceTokenId)
        FROM
            fire_base_persons_info f
        WHERE
            parent.userId = f.userId) AS DEVICE_ID,
    (CASE
        WHEN
            T8.logoUrl IS NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl,
                    '/',
                    'emailer/images/logo_default_image.png')
        WHEN
            T8.logoUrl IS NULL
                AND org.orgUrl IS NULL
        THEN
            'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', T8.logoUrl)
    END) AS LOGO_URL,
    (CASE
        WHEN
            T8.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T8.headerUrl)
        ELSE NULL
    END) AS HEADER_URL
FROM
    infirmary_details T1
		INNER JOIN
    parent_infirmary_details pid ON pid.infirmaryId = T1.id
        LEFT JOIN
    sections T2 ON T2.id = T1.sectionId
        LEFT OUTER JOIN
    academy_location T8 ON T8.id = T1.academyLocationId
        LEFT JOIN
    users doc ON doc.id = T1.doctorUserId        
        LEFT JOIN
    users stu ON stu.id = T1.userId
        LEFT JOIN
    infirmary_reason infRes ON infRes.id = T1.infirmaryReasonId        
		LEFT JOIN
    persons perPer ON perPer.id = pid.personId
        LEFT JOIN
    parents parent ON parent.personId = perPer.id
        LEFT OUTER JOIN
    organizations org ON org.id = (SELECT MAX(id) FROM organizations)
WHERE
    pid.id IN (namedParams)
        AND T1.type = 'CLINIC'" WHERE `dataProviderId`=@clinicDtProviderId1;       

        
-- Infirmary Intervention Parent

SET @intervDtProviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='INTERVENTION_APPOINTMENT_PARENT_DL');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    T2.id AS USER_ID
FROM
    parent_infirmary_details T2
        INNER JOIN
    infirmary_details T1 ON T1.id = T2.infirmaryId
WHERE
    T1.type = 'INTERVENTION'
        AND T1.whetherParentInformed = TRUE
        AND T2.infirmaryId IN (namedParams)" WHERE `dataProviderId`=@intervDtProviderId;
        
SET @intervDtProviderId1=(SELECT id FROM dtprovider WHERE `dataProviderName`='INTERVENTION_APPOINTMENT_PARENT_RCPNT');


UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT 
    pid.id AS ID,
    perPer.`firstName` AS FIRST_NAME,
    perPer.`lastName` AS LAST_NAME,
    perPer.printName AS PRINT_NAME,
    perPer.`emailId` AS EMAIL_ID,
    perPer.`mobileNumber` AS MOBILE_NO,
    doc.printName AS DOC_PRINT_NAME,
    doc.firstName AS DOC_FIRST_NAME,
    doc.lastName AS DOC_LAST_NAME,
    stu.printName AS STUDENT_PRINT_NAME,
    stu.firstName AS STUDENT_FIRST_NAME,
    stu.lastName AS STUDENT_LAST_NAME,
    T2.sectionCode AS SECTION_CODE,
    infRes.itemValue AS REASON,
    DATE_FORMAT(T1.infirmaryDate, '%d-%m-%Y') AS VISIT_DATE,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T8.academyName AS ACADEMY_NAME,
    (SELECT 
            GROUP_CONCAT(DISTINCT deviceTokenId)
        FROM
            fire_base_persons_info f
        WHERE
            parent.userId = f.userId) AS DEVICE_ID,
    (CASE
        WHEN
            T8.logoUrl IS NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl,
                    '/',
                    'emailer/images/logo_default_image.png')
        WHEN
            T8.logoUrl IS NULL
                AND org.orgUrl IS NULL
        THEN
            'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', T8.logoUrl)
    END) AS LOGO_URL,
    (CASE
        WHEN
            T8.headerUrl IS NOT NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl, '/', T8.headerUrl)
        ELSE NULL
    END) AS HEADER_URL
FROM
    infirmary_details T1
        INNER JOIN
    parent_infirmary_details pid ON pid.infirmaryId = T1.id
        LEFT JOIN
    sections T2 ON T2.id = T1.sectionId
        LEFT OUTER JOIN
    academy_location T8 ON T8.id = T1.academyLocationId
        LEFT JOIN
    users doc ON doc.id = T1.doctorUserId
        LEFT JOIN
    persons perPer ON perPer.id = pid.personId
        LEFT JOIN
    parents parent ON parent.personId = perPer.id
        LEFT JOIN
    users stu ON stu.id = T1.userId
        LEFT JOIN
    infirmary_reason infRes ON infRes.id = T1.infirmaryReasonId
        LEFT OUTER JOIN
    organizations org ON org.id = (SELECT MAX(id) FROM organizations)
WHERE
    pid.id IN (namedParams)
        AND T1.type = 'INTERVENTION'" WHERE `dataProviderId`=@intervDtProviderId1;  
      


set sql_safe_updates=1;

